<?php
// ##obfuscate##
//
// Copyright P.Kassel, M.Seliger, G.Trietsch, all Rights Reserved
//

/**
 *
 * @param string $langdir
 * @param string $stringfile
 */
function tbGetInstalledLanguages ($langdir, $stringfile)
{
  $languages = array();

  if ( is_dir ($langdir) )
  {
    if ( $handle = opendir($langdir) )
    {
      chdir ( $langdir );
      while ( false !== ($file = readdir($handle)) )
      {
        if ( $file != "." && $file != ".." )
        {
          if ( is_dir($file) )
          {
            chdir ( $file );
            if ( file_exists ($stringfile) )
            {
              $hLang = fopen ( $stringfile, "r" );
              $buffer = "";
              $langcode = strtolower($file);

              if ( ! feof($hLang) )
              {
                fgets ( $hLang, 4096 );
                $buffer = fgets ( $hLang, 4096 );
                $tok = explode ( "#", $buffer );

                if ( count ($tok) > 1 )
                  $buffer = $tok[1];
                else
                  $buffer = $langcode;

                unset ($tok);
              }
              fclose ( $hLang );

              $languages[$langcode] = $buffer;

              unset ($buffer);
              unset ($hLang);
            }
            chdir("../");
          }
        }
      }
      unset ($file);

      chdir("../");
    }
    closedir($handle);
    unset($handle);
  }

  asort ($languages);

  return $languages;
}


/**
 *
 * @param array  $inst_languages (out)
 * @param array  $cfg
 * @param string $langdir
 * @param string $stringfile
 */
function tbInitLanguage (& $inst_languages, & $cfg, $langdir, $stringfile)
{
  $ServerLanguage = isset($_SERVER['HTTP_ACCEPT_LANGUAGE']) && $_SERVER['HTTP_ACCEPT_LANGUAGE'] != '' ?
  $_SERVER['HTTP_ACCEPT_LANGUAGE'] : 'en';

  if (!isset($_SESSION) ||
      !isset ($_SESSION['HTTP_ACCEPT_LANGUAGE']) || $_SESSION['HTTP_ACCEPT_LANGUAGE'] != $ServerLanguage ||
      !isset($_SESSION['language']))
  {
    $inst_languages = tbGetInstalledLanguages($langdir, $stringfile);

    // Erstmalige Initialisierung
    if (isset($_SESSION))
    {
      $_SESSION['HTTP_ACCEPT_LANGUAGE'] = $ServerLanguage;
      $_SESSION['Languages'] = $inst_languages;
    }
    else
      tbSetLanguage ($cfg, "en", "");

    // Active language
    $lang = tbGetAcceptedLanguages ();

    for ($i = 0; isset($lang[$i]); $i++)
    {
      $fullang = strtolower($lang[$i]['language']);

      $langparts = explode ('-', $fullang);

      $mainlang = strtolower($langparts[0]);

      if ($mainlang != '*')
      {
        $sublang = strtolower(isset($langparts[1]) ? $langparts[1] : '');

        //tbCheckAliasLanguage ($fullang, $mainlang, $sublang);

        if ( $sublang != '' && is_dir ($langdir. $fullang) )
        {
          tbSetLanguage ($cfg, $mainlang, $sublang);
          break;
        }
        else if ( is_dir ($langdir. $mainlang) )
        {
          tbSetLanguage ($cfg, $mainlang, '');
          break;
        }
      }
    }

    // Ist die gewünschte Sprache nicht installiert, liefern wir Englisch    
    if ( !isset($cfg['language']) )
    {
      $cfg['language'] = 'en';
      $cfg['mainlang'] = 'en';
      $cfg['sublang']  = '';
    }
  }
  else if (isset($_SESSION) && !isset ($cfg['language']))
  {
    $inst_languages = $_SESSION['Languages'];

    $cfg['language'] = $_SESSION['language'];
    $cfg['mainlang'] = $_SESSION['mainlang'];
    $cfg['sublang']  = $_SESSION['sublang'];
  }
}


/**
 * @return array language list (descending order by quality)
 */
function tbGetAcceptedLanguages()
{
  $languages = array();

  if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE']))
  {
    $hal_string = str_replace(' ', '', $_SERVER['HTTP_ACCEPT_LANGUAGE']);

    $hal_array = explode(',', $hal_string);

    $i = 0;

    foreach ($hal_array as $hal)
    {
      $strings = explode(';', $hal);

      if (!isset($strings[1]))
        $strings[1] = 'q=1.0';

      $languages[$i] = array();
      $languages[$i]['position'] = $i;
      $languages[$i]['language'] = $strings[0];
      $languages[$i]['quality']  = $strings[1];

      $i++;
    }

    $quality  = array();
    $position = array();

    foreach ($languages as $key => $value)
    {
      $quality[$key]  = $value['quality'];
      $position[$key] = $value['position'];
    }

    array_multisort($quality, SORT_DESC, $position, SORT_ASC, $languages);
  }
  else
    $languages[0]['language'] = 'en';

  return $languages;
}


/**
 *
 * @param array  $cfg
 * @param string $mainlang
 * @param string $sublang
 */
function tbSetLanguage (& $cfg, $mainlang, $sublang)
{
  $cfg['language'] = $mainlang . (isset($sublang) && $sublang != '' ? ('-'.$sublang) : '');
  $cfg['mainlang'] = $mainlang;
  $cfg['sublang']  = $sublang;

  if (isset($_SESSION))
  {
    $_SESSION['language'] = $cfg['language'];
    $_SESSION['mainlang'] = $cfg['mainlang'];
    $_SESSION['sublang']  = $cfg['sublang'];
  }
}


/**
 *
 * @param string $filepath
 * @param string $fileexists
 * @return string
 */
function tbLangDirName ( $filepath, $fileexists = '' )
{
  global $cfg;

  $Result = str_replace ('%LANG%', $cfg['language'], $filepath);

  if ( file_exists ($Result . $fileexists) == false )
  {
    $Result = str_replace ('%LANG%', $cfg['mainlang'], $filepath);

    if ( file_exists ($Result . $fileexists) == false )
      $Result = str_replace ('%LANG%', 'en', $filepath);
  }

  return $Result;
}

?>
