<?php
#Português

//
// ☺ utf-8 Language File
// Copyright P.Kassel, M.Seliger, G.Trietsch, all Rights Reserved
//

global $oem;

// region settings
$cfg['dec_point'] = '.';
$cfg['thousands_sep'] = ',';
$cfg['timestamp_fmt'] = 'm/d/Y H:i:s';
$cfg['shorttimestamp_fmt'] = 'm/d/Y h:i a';
$cfg['simpletimestamp_fmt'] = 'm/d/Y';
$cfg['cal_fmt'] = 'm/d/Y';
$cfg['oclock'] = 'g a';

// common strings
$str['UnsuportedBrowser'] = 'Este browser está desatualizado e já não é suportado!';
$str['apply'] = "Apply";
$str['ok'] = "OK";
$str['cancel'] = "Cancel";
$str['yes'] = "Yes";
$str['no'] = "No";
$str['eg'] = "e.g.";
$str['help'] = "Help";
$str['copy'] = "Copy";
$str['dev_unreachable'] = "Not reachable";
$str['timezone'] = "Timezone";
$str['export'] = "Export";
$str['import'] = "Import";
$str['no_html5_browser'] = "This browser does not support HTML5";
$str['mark_row'] = "Row {0}";
$str['mark_row_all'] = "Mark all rows";
$str['disconnected_caption'] = "Connection to service lost";
$str['disconnected_msg'] = "If the service is available again, you will be redirected to the login page.";
$str['attention_img'] = "Attention";
$str['ext_hpjam'] = "HP Smart Device Services";
$str['ext_hpjam_short'] = "HP SDS";
$str['ctype_usb'] = "USB";
$str['fctn_unknown_error'] = "An error occured";

// tree menu
$str['menutree'] = "Site content";
$str['Menu_Printers'] = "Printer";
$str['Menu_Labelcf'] = "Continuous Paper & Labels";
$str['Menu_System'] = "System";
$str['Menu_Devscan'] = "Search Printers";
$str['Menu_Setdfue'] = "Transfer Printer Data";
$str['Menu_Pmdupdate'] = "Manage PMD Files";
$str['Menu_Identifiers'] = "Source Identifiers";
$str['Menu_Network'] = "Network Settings";
$str['Menu_Setdb'] = "Database";
$str['Menu_Settings'] = "Settings";
$str['Menu_Extensions'] = "Extensions";
$str['Menu_HpJam'] = $str['ext_hpjam'];
$str['Menu_Devtools'] = "Developer tools";
$str['Menu_Help'] = "Help";
$str['Menu_Logout'] = "Logout";

// menu titles
$str['Title_Printers'] = "Printer";
$str['Title_LabelCF'] = "Continuous Paper and Labels";
$str['Title_System'] = "System";
$str['Title_DevScan'] = "Search Printers";
$str['Title_PmdUpdate'] = "Manage PMD Files";
$str['Title_Setdfue'] = "Data Transfer";
$str['Title_Identifiers'] = "Source Identifiers";
$str['Title_Network'] = "Network Settings";
$str['Title_Setdb'] = "Database";
$str['Title_Settings'] = "Settings";
$str['Title_Extensions'] = "Extensions";

// login dialog
$str['Login_Javascript'] = 'Please activate Javascript!';
$str['Login_Authentication'] = "Authentication";
$str['Login_Password'] = "Password:";
$str['Login_Login'] = "Login";
$str['Login_ResetPW'] = 'Forgot your password?';
$str['Login_AskResetPW'] = 'Do you want to send an e-mail with a new password to the receiver of the system events?';
$str['Login_PasswordReset'] = 'An email will be sent to the specified email receiver. If you don\'t receive the email, please check your spam folder.';
$str['Login_ResetPWError'] = 'Reset password failed';
$str['ChangePassword'] = 'The password was reset. Please change your password immediately';
$str['Login_InvalidLogin'] = "Access denied.";
$str['Login_InvalidLicense'] = "Authentication is currently disabled due to a missing or invalid license.";
$str['Login_Maintenance'] = "Authentication is currently disabled due to server maintenance.";
$str['Login_Update'] = "Authentication is currently disabled due to a software update.";
$str['Login_SessionInvalid'] = "Connection to service lost.";
$str['Login_SessionTimeout'] = "Your session has timed out.";

// main page
$str['main_productinfo'] = "Product Information";
$str['main_clientuuid'] = "ID";
$str['main_statusinfo'] = "Status Information";
$str['main_lastupdate'] = "Installation date";
$str['main_lastupdatecheck'] = "Last update check";
$str['main_lastdevscan'] = "Last printer search";
$str['main_lasttransfer'] = "Last data transfer";
$str['main_lastpmdupdate'] = "Last PMD file update";
$str['main_copyright'] = "Copyright";
$str['main_config_email'] = "Please specify an e-mail receiver at 'Settings' for receiving an e-mail in case of forgotten password";

// printers page
$str['prnlst_summary'] = "The table lists the known printers of source identifier %s in %u columns";
$str['prnlst_caption'] = "Source identifier";
if ( $oem['submitterlabel'] != "" )
  $str['prnlst_caption'] .= ' ('.$oem['submitterlabel'].')';
$str['prnlst_identifier_label'] = "Select an identifier for which you want to show a printer list";
$str['prnlst_clearfilter'] = "Clear filter";
$str['prnlst_of'] = "of";
$str['prnlst_activity'] = "State";
$str['prnlst_model'] = "Model";
$str['prnlst_printer'] = "Printer";
$str['prnlst_macaddress'] = "MAC";
$str['prnlst_serialno'] = "Serial";
$str['prnlst_ciid'] = "CI-ID";
$str['prnlst_labelcf'] = "Continuous Paper/Label";
$str['prnlst_labelcfautoformat'] = "<reported by printer>";
$str['prnlst_lastwalk'] = "Acquired on";
$str['prnlst_pmd'] = "PMD File";
$str['prnlst_confirmdel'] = "Do you really want to delete the selected printers?";
$str['prnlst_acquire'] = "Acquire data";
$str['prnlst_btn_on'] = "Activate";
$str['prnlst_btn_off'] = "Deactivate";
$str['prnlst_tit_acquire'] = "Triggers data acquisition of the selected printers";
$str['prnlst_btn_activation'] = "Monitoring";
$str['prnlst_tit_activation'] = "Controls data monitoring of the selected printers";
$str['prnlst_btn_f2p'] = "Follow2Print";
$str['prnlst_tit_f2p'] = "Controls Follow2Print support for selected printers";
$str['prnlst_btn_secureprint'] = "Secure Print";
$str['prnlst_tit_secureprint'] = "Controls Secure Print support for selected printers";
$str['prnlst_secon'] = "Secure Print on";
$str['prnlst_tit_secon'] = "Activates Secure Print support for selected printers.";
$str['prnlst_secoff'] = "Secure Print off";
$str['prnlst_tit_secoff'] = "Dectivates Secure Print support for selected printers.";
$str['prnlst_delete'] = "Delete";
$str['prnlst_tit_delete'] = "Deletes selected printers";
$str['prnlst_tit_export'] = "Exports all printers to a csv file.";
$str['prnlst_tit_import'] = "Imports printers from a csv file.";
$str['prnlst_activated'] = "Printer is active";
$str['prnlst_alt_activated'] = "Active";
$str['prnlst_deactivated'] = "Printer is not active";
$str['prnlst_alt_deactivated'] = "Not active";
$str['prnlst_notlicensed'] = "Printer is not licensed";
$str['prnlst_alt_notlicensed'] = "Not licensed";
$str['prnlst_pmdprotected'] = "This file is protected";
$str['prnlst_alt_pmdprotected'] = "Protected";
$str['prnlst_postscript'] = "Printer supports Postscript";
$str['prnlst_alt_postscript'] = "Postscript";
$str['prnlst_escp'] = "Printer supports EPSON ESC/P";
$str['prnlst_alt_escp'] = "ESC/P";
$str['prnlst_follow2print'] = "Printer can be used for Follow2Print";
$str['prnlst_alt_follow2print'] = "Follow2Print";
$str['prnlst_secureprint'] = "Printer supports Secure Print";
$str['prnlst_alt_secureprint'] = "Secure Print";
$str['prnlst_csvimportcaption'] = "Import printers";
$str['prnlst_waitingcaption'] = 'Please wait';
$str['prnlst_waitingmessage'] = 'Importing printers...';
$str['prnlst_waitingimgalt'] = 'Process:';
$str['prnlst_prttotal'] = 'Printers total';
$str['prnlst_prtvalidated'] = ' - confirmed';

$str['Import_done'] = "Import successfully done.";
$str['Import_failed'] = "The file couldn't be uploaded.";

// labelcf page
$str['labelcf_caption'] = "Source Identifier";
if ( $oem['submitterlabel'] != "" )
  $str['labelcf_caption'] .= ' ('.$oem['submitterlabel'].')';

// pmdupdate page
$str['pmd_updatecaption'] = "PMD File Update";
$str['pmd_update_tabitem1'] = "File";
$str['pmd_uploadfailed'] = "The selected PMD file couldn't be transferred!";
$str['pmd_listcaption'] = "Printers without PMD Files";
$str['pmd_labeladdress'] = "Adress";
$str['pmd_labelmodel'] = "Model";
$str['pmd_unknownmodel'] = "unknown model";
$str['pmd_searchupdates'] = "Search for online available PMD file updates";
$str['pmd_downloadupdates'] = "Download and install online available PMD files";
$str['pmd_autoupdates'] = "Update PMD files automatically";
$str['pmd_directlinkprefix'] = "Problems with the update? Please use this ";
$str['pmd_directlink']= "direct link";
$str['pmd_directlinksuffix']= " and install the update manually";
$str['pmd_uploadfile'] = "Select a PMD file or an PMD archive for a manual update:";
$str['pmd_uploadfilehint'] = '(To manually start the update process click the button "Apply")';
$str['pmd_extcounterscaption'] = "PMD files with extended counter definitions";
$str['pmd_selectpmdmodels'] = "Check the printer models whose extended counters should be queried:";
$str['pmd_pmdmodels'] = "Printer models";
$str['pmd_lastupdate'] = "Last update:";
$str['pmd_lastupdateunknown'] = "unknown";

// setdb page
$str['setdb_caption'] = "ODBC Database";
$str['setdb_dsn'] = "Data Source:";
$str['setdb_user'] = "User Name:";
$str['setdb_pwd'] = "Password:";
$str['setdb_test'] = "Test Connection";
$str['setdb_test_ok'] = "Successfully connected to the ODBC data source.";
$str['setdb_test_failed'] = "Connection to the ODBC data source failed!";
$str['setdb_failed'] = "Change of the ODBC data source failed!";

// settings page
$str['setpwd_caption'] = "System Password";
$str['setpwd_current'] = "Current Password:";
$str['setpwd_new'] = "New Password:";
$str['setpwd_check'] = "Verify Password:";
$str['setsyspwd_ok'] = "The password have been changed successfully.";
$str['setsyspwd_checkerror'] = "Password verification failed!";
$str['setsyspwd_failed'] = "The password couldn't be changed!";
$str['sysemail_caption'] = "System Events";
$str['sysemail_address'] = "E-mail receiver";

$str['syspurge_caption'] = "Automatic deletion of printers";
$str['syspurge_text'] = "Days after which printers that can no longer be reached are deleted";

$str['upd_no_fsmwebsrvaddr'] = "Please enter the address of the MPS web server on the network settings page, to perform an software update!";
$str['upd_caption'] = "Software Update";
$str['upd_checking'] = "Checking for update";
$str['upd_downloading'] = "Downloading software update";
$str['upd_installing'] = "Installing software update";
$str['upd_unpacking'] = "Unpacking setup files";
$str['upd_check_failed'] = "Update check failed";
$str['upd_errorcode'] = "error code";
$str['upd_unknown_error'] = "unspecified error";
$str['upd_active'] = "Check and install software updates automatically";
$str['upd_last_check'] = "Last checked for update on";
$str['upd_check_now'] = "Check for update";
$str['upd_update_now'] = "Install update";
$str['upd_uptodate'] = "No update available";
$str['upd_available1'] = "Update";
$str['upd_available2'] = "available";
$str['upd_client_denied'] = "Client unknown or not allowed";
$str['upd_invalid_password'] = "Invalid password";
$str['upd_warning_caption'] = "Update Warning";
$str['upd_warning'] = "During installation, the connection is interrupted and the service will be closed, downloaded and updated. Do you want to perform the update now?";
$str['csv_caption'] = "CSV files";
$str['csv_delimiter'] = "Field delimiter";
$str['csv_tabdelimiter'] = "tab";
$str['csv_syncprinters'] = "Delete printers that are not listed in csv import files anymore";

// client update
$str['upd_err_200x'] = "HTTP POST error";
$str['upd_err_300x'] = "Download error";
$str['upd_err_400x'] = "Unpack error";
$str['upd_err_500x'] = "Setup error";
$str['upd_err_5002'] = "Setup pending";

// devscan page
$str['devscan_identifier_caption'] = "Source Identifier";
if ( $oem['submitterlabel'] != "" )
  $str['devscan_identifier_caption'] .= ' ('.$oem['submitterlabel'].')';
$str['devscan_schedule_caption'] = "Automatic search";
$str['devscan_identifier_label'] = "Select an identifier for which you want to set up search options";
$str['devscan_scannow'] = "Search now";
$str['devscan_lastscan'] = "Last search";
$str['devscan_lastscanunknown'] = "unknown";

$str['devscan_ranges'] = "Network Ranges";
$str['devscan_eg'] = "e.g.";
$str['devscan_net'] = "Network address:";
$str['devscan_netprefix'] = "Address:";
$str['devscan_netbits'] = "Bits:";
$str['devscan_netmask'] = "Subnet mask:";
$str['devscan_scan_method'] = "Search method";
$str['devscan_scan_scan'] = "Scan";
$str['devscan_scan_broadcast'] = "Broadcast";
$str['devscan_scan_from'] = "From IP Address:";
$str['devscan_scan_to'] = "To IP Address:";
$str['devscan_scan_addr_err'] = "IP address is not a member of the network!";
$str['devscan_scan_addr_low'] = "End of IP address range ist smaller than start!";
$str['devscan_overlap'] = "There is an overlap with entry:\\r\\n\\r\\n";
$str['devscan_snmp_version1'] = "v1/v2 only";
$str['devscan_snmp_version3'] = "v3 only";
$str['devscan_snmp_version4'] = "v1/v2/v3";
$str['devscan_udp_port'] = "UDP port:";
$str['devscan_udp_defport'] = "Def.";
$str['devscan_udp_defport_hint'] = "Default UDP port for SNMP communication";
$str['devscan_udp_extport'] = "Ext.";
$str['devscan_udp_extport_hint'] = "UDP port used by SNMP Extenders";
$str['devscan_snmp_version'] = "SNMP version:";
$str['devscan_snmp_community'] = "Community:";
$str['devscan_snmp_securityname'] = "User name:";
$str['devscan_snmp_contextname'] = "Context name:";
$str['devscan_snmp_authprotocol'] = "Authentication protocol:";
$str['devscan_snmp_authprotocol0'] = "<none>";
$str['devscan_snmp_authprotocol1'] = "MD5";
$str['devscan_snmp_authprotocol2'] = "SHA";
$str['devscan_snmp_authprotocol3'] = "SHA224";
$str['devscan_snmp_authprotocol4'] = "SHA256";
$str['devscan_snmp_authprotocol5'] = "SHA384";
$str['devscan_snmp_authprotocol6'] = "SHA512";
$str['devscan_snmp_authpassword'] = "Authentication password:";
$str['devscan_snmp_privprotocol'] = "Encryption protocol:";
$str['devscan_snmp_privprotocol0'] = "<none>";
$str['devscan_snmp_privprotocol1'] = "DES";
$str['devscan_snmp_privprotocol2'] = "AES128";
$str['devscan_snmp_privpassword'] = "Encryption password:";
$str['devscan_scan_ranges'] = "Scan ranges:";
$str['devscan_add'] = "Add";
$str['devscan_del'] = "Delete";

$str['devscan_snmp_credentials'] = "SNMP v3 Credentials";
$str['devscan_snmp_names'] = "User names:";
$str['devscan_snmp_password'] = "Password:";
$str['devscan_import_error'] = "Error in line %1: SNMP user name %2 is unknown. Line was skipped.";

$str['devscan_onoff'] = "Search printers automatically";
$str['devscan_autohour_1'] = "Begin search at";
$str['devscan_autohour_2'] = "";
$str['devscan_autorepeat_1'] = "Repeat after";
$str['devscan_autorepeat_2'] = "";
$str['devscan_hours'] = "hours";
$str['devscan_days'] = "days";
$str['devscan_weeks'] = "weeks";
$str['devscan_alwaysmonitor'] = "Automatically activate new printers";
$str['devscan_confirmchanges'] = "Apply changes before changing source identifiers?";
$str['devscan_csvimportcaption'] = "Import printers";
$str['devscan_csvimportlabel'] = 'To import known printers, choose a CSV file and start the import process by clicking "OK"';

// network page
$str['fsmlocaddr_caption'] = "Local IP address for printer announcement from server";
$str['fsmlocaddr_description'] = "Select the local IP address under which this client can be reached by the MPS Server";
$str['fsmlocaddr_address'] = "IP Address";
$str['fsmweb_caption'] = "MPS Web Server";
$str['fsmweb_description'] = "Certain features (such as software update) require a connection to the MPS web server";
$str['fsmweb_srvaddress'] = "HTTP(S) web address";
$str['fsmweb_certauth'] = "Valid SSL certificate required";
$str['smtp_caption'] = "SMTP E-mail Server";
$str['smtp_fromaddress'] = "Sender E-mail Address:";
$str['smtp_server'] = "Server Address:";
$str['smtp_port'] = "Server Port:";
$str['smtp_ssl'] = "Security:";
$str['smtp_ssl_none'] = "None";
$str['smtp_ssl_ssltls'] = "SSL/TLS";
$str['smtp_ssl_starttls'] = "STARTTLS";
$str['smtp_ssl_msoauth'] = "OAUTH2 (Entra ID)";
$str['smtp_user'] = "E-mail Username:";
$str['smtp_pwd'] = "Password:";

$str['msoauthCaption'] = 'OAUTH2 Authentication at Entra ID';
$str['msoauthMessage'] = 'The use of OAUTH2 for Entra ID requires a one-time authentication. '.
  'This can only be done on the same system on which the service is active. '.
  'To do this, execute the "Entra ID authentication" entry from the start menu';
$str['msoauthBtn'] = 'Continue';

$str['mapi_caption'] = "Exchange Server (MAPI)";
$str['mapi_hint'] = "To be able to send e-mails through a Microsoft Exchange server you have to use a user related profile. Such a profile contains the configuration of the service provider (here: Microsoft Exchange Server) which will be used to transmit the e-mail. For that you have to specify the user account data and the name of the exchange profile here.";
$str['mapi_user'] = "User Name:";
$str['mapi_domain'] = "Domain:";
$str['mapi_pwd'] = "Password:";
$str['mapi_profile'] = "Profile:";
$str['smtp_failed'] = "Mail server changes couldn't be applied!";
$str['setproxy_caption'] = "Proxy configuration";
$str['setproxy_enabled'] = "Use a proxy server to connect to the internet";
$str['setproxy_server'] = "Server Address:";
$str['setproxy_port'] = "Server Port:";
$str['setproxy_user'] = "User Name:";
$str['setproxy_pwd'] = "Password:";

// dfue page
$str['dfue_dataacquire'] = "Data Acquisition";
$str['dfue_minacquirecycle'] = "Acquisition Cycle:";
$str['dfue_acquirenow'] = "Acquire now";
$str['dfue_mincycle1'] = "every hour";
$str['dfue_mincycle2'] = "every 2 hours";
$str['dfue_mincycle3'] = "every 3 hours";
$str['dfue_mincycle4'] = "every 4 hours";
$str['dfue_mincycle6'] = "every 6 hours";
$str['dfue_mincycle12'] = "every 12 hours";
$str['dfue_mincycle24'] = "every 24 hours";
$str['dfue_gpdsupport'] = "Activate ".$oem['name']." GPI support";
$str['dfue_gpdonly'] = "Enable data transfer to MPS Server";
$str['dfue_datatransfer'] = "Data Transfer";
$str['dfue_transfertime'] = "Transfer Interval:";
$str['dfue_transferhour_1'] = "start at";
$str['dfue_transferhour_2'] = "";
$str['dfue_transfermode'] = "Transfer Mode:";
$str['dfue_tm_email'] = "Email";
$str['dfue_tm_xmlrpc'] = "XML-RPC";
$str['dfue_tm_both'] = "XML-RPC & Email";
$str['dfue_tm_https'] = "HTTP(S)";
$str['dfue_xmlrpchost'] = "XML-RPC Receiver Host:";
$str['dfue_emailto'] = "Email Receiver Address:";
$str['dfue_httpsurl'] = "HTTP(S) upload URL:";
$str['dfue_cryptpwd'] = "Data Encryption Key:";
$str['dfue_setfailed'] = "Data transfer settings couldn't be changed! ";
$str['dfue_everyhour'] = "every hour";
$str['dfue_every3hours'] = "every 3 hours";
$str['dfue_every4hours'] = "every 4 hours";
$str['dfue_every5hours'] = "every 5 hours";
$str['dfue_every6hours'] = "every 6 hours";
$str['dfue_every8hours'] = "every 8 hours";
$str['dfue_every12hours'] = "every 12 hours";
$str['dfue_daily'] = "every day";
$str['dfue_everySun'] = "every week on sunday";
$str['dfue_StartOfMonth'] = "at beginning of the month";
$str['dfue_EndOfMonth'] = "at the end of the month";
$str['dfue_Every3Month'] = "at the end of the quarter";
$str['dfue_sendnow'] = "Send data now";
$str['dfue_askclearqueue'] = "Do you realy want to delete all unsent data?";
$str['dfue_clearqueue'] = "Abandon data";
$str['dfue_PrinterEventsCaption'] = 'Printer messages';
$str['dfue_PrinterEventsTab1Caption'] = 'Selection';
$str['dfue_PrinterEventsTab2Caption'] = 'Priority';
$str['dfue_PrinterEventsTab1Label'] = 'Check messages which you want to be monitored:';
$str['dfue_PrinterEventsTab2Label'] = 'Check the monitored messages that should be transfered independently from the transfer interval in a timely fashion:';
$str['dfue_HiPrioPrnErrorDefaults'] = 'Recommended messages';
$str['dfue_PrnError1'] = 'Service required';
$str['dfue_PrnError2'] = 'Offline';
$str['dfue_PrnError4'] = 'Paper jam';
$str['dfue_PrnError8'] = 'Door open';
$str['dfue_PrnError16'] = 'No toner';
$str['dfue_PrnError32'] = 'Toner low';
$str['dfue_PrnError64'] = 'No paper';
$str['dfue_PrnError128'] = 'Paper low';
$str['dfue_PrnError256'] = '';
$str['dfue_PrnError512'] = 'Overdue maintenance';
$str['dfue_PrnError1024'] = 'Input tray empty';
$str['dfue_PrnError2048'] = 'Output bin full';
$str['dfue_PrnError4096'] = 'Output bin nearly full';
$str['dfue_PrnError8192'] = 'Toner supply missing';
$str['dfue_PrnError16384'] = 'Output bin missing';
$str['dfue_PrnError32768'] = 'Paper tray missing';
$str['dfue_PrnError1048576'] = 'No response from printer';

// identifiers page
$str['identifiers_caption'] = "Source Identifier";
if ( $oem['submitterlabel'] != "" )
  $str['identifiers_caption'] .= ' ('.$oem['submitterlabel'].')';
$str['identifiers_update'] = "Change";
$str['identifiers_add'] = "Add";
$str['identifiers_del'] = "Delete";
$str['identifiers_edit'] = "Name:";
$str['identifiers_list'] = "Identifiers:";
$str['identifiers_local'] = "Identifier for local printers:";
$str['identifiers_none'] = "<None>";
$str['identifiers_alert_del'] = "The base source identifier cannot be deleted!";
$str['identifiers_confirm_del'] = "Do you really want to delete this source identifier?\\r\\n\\r\\nNote: All printers and data, which have been collected for this source identifier, will also be deleted.";

// HP JetAdvantage Management
$str['hpjam_caption'] = $str['ext_hpjam'];
$str['hpjam_enabled'] = "Enable support for ".$str['hpjam_caption'];
$str['hpjam_nextannouncement'] = "Next announcement of printers to connector in %u minutes";
$str['hpjam_nextquery'] = "Next printer state query from connector in %u Minuten";
$str['hpjam_connector_caption'] = "Connector configuration";
$str['hpjam_connectorpage_title'] = "HP Connector configuration page";
$str['hpjam_eula_caption'] = "License Agreement and Data Privacy Statement";
$str['hpjam_privacy_title'] = "Data privacy statement for the use of ".$str['hpjam_caption'];
$str['hpjam_eula_title'] = "Eula for the use of ".$str['hpjam_caption'];
$str['hpjam_eula_agree'] = "Do you accept the end user license agreement?";
$str['hpjam_deactivate_caption'] = "Confirmation";
$str['hpjam_deactivate_text'] = "Do you really want to deactivate support for ".$str['hpjam_caption']."?";
$str['hpjam_download_nourl'] = "Please enter the address of the MPS web server on the network settings page, so you can download the HP connector software!";
$str['hpjam_linkprefix'] = "The ".$str['hpjam_caption']." connector still needs to be installed. Please click ";
$str['hpjam_link'] = "here";
$str['hpjam_linksuffix'] = " to download and install the software.";
$str['hpjam_fsmjamcexe'] = "MPS HP Connector Setup.exe";
$str['hpjam_register_nourl'] = "Please enter the address of the MPS web server on the network settings page, so you can register the HP connector software!";
$str['hpjam_register_desc'] = "The ".$str['hpjam_caption']." connector needs to be registered. Please click the button.";
$str['hpjam_register_button'] = "Register now";
$str['hpjam_register_inprogress'] = "Registration in progress";
$str['hpjam_register_canceled'] = "Registration canceled";
$str['hpjam_register_error'] = "The connector couldn't be registered.";
$str['hpjam_register_ok'] = "The connector was successfully registered.";
$str['hpjam_prnlst'] = "Printer supports ".$str['hpjam_caption'];
$str['hpjam_prnlst_announced'] = "Printer has been reported to ".$str['hpjam_caption'];
$str['hpjam_prnlst_alt'] = $str['hpjam_caption'];
$str['hpjam_note'] = "Note";
$str['hpjam']['note']['NoApiKey'] = "To support all features, the HP SDS Connector needs to be reinstalled";
$str['hpjam_status'] = "Status";
$str['hpjam']['status']['OK'] = "OK";
$str['hpjam']['status']['Unknown'] = "Unknown";
$str['hpjam']['status']['NotActive'] = "Not active";
$str['hpjam']['status']['NotAvailable'] = "Not available";
$str['hpjam']['status']['NotInstalled'] = "Connector not installed";
$str['hpjam']['status']['Installing'] = "The Connector is being installed. Please be patient. The setup may take some time.";
$str['hpjam']['status']['NotRunning'] = "Connector service not running";
$str['hpjam']['status']['NotRegistered'] = "Connector not registered";
$str['hpjam']['status']['InvalidRegistrationKey'] = "Invalid registration key";
$str['hpjam']['status']['Initializing'] = "Initializing";
$str['hpjam']['status']['Registered'] = "Registered";
$str['hpjam']['status']['Registering'] = "Registering";
$str['hpjam']['status']['Online'] = "Online";
$str['hpjam']['status']['Offline'] = "Offline";
$str['hpjam']['status']['CommunicationError'] = "Communication Error";
$str['hpjam']['status']['ServiceNotStarted'] = "Service not started";
$str['hpjam']['status']['InvalidCertificate'] = "Invalid certificate";
$str['hpjam']['status']['CannotFetchCertificateRevocationList'] = "Cannot fetch certificate revocation list";
$str['hpjam']['status']['CertificateValidated'] = "Certificate validated";
$str['hpjam']['status']['ProxySettingsVerify'] = "Proxy settings verify";
$str['hpjam']['status']['AttemptingLogOn'] = "Attempting log on";
$str['hpjam']['status']['LogOnFailed'] = "Log on failed";
$str['hpjam']['error']['Reason'] = "Reason";
$str['hpjam']['error']['ApiCallFailed'] = "The register function returned an error";
$str['hpjam']['error']['ApiCallTimedOut'] = "The register function timed out";
$str['hpjam']['error']['ConfigServerInvalid'] = "Invalid configuration server";
$str['hpjam']['error']['InvalidServerState'] = "Invalid server state";
$str['hpjam']['error']['HpjamNotSupported'] = $str['ext_hpjam'] . " not supported by server";
$str['hpjam']['error']['AdminMaintenance'] = "Connector registration is currently disabled due to server maintenance";
$str['hpjam']['error']['DbConnectionFailed'] = "Connection to server database failed";
$str['hpjam']['error']['BadRequest'] = "Invalid or missing registration data";
$str['hpjam']['error']['ServerError'] = "An internal server error occurred";
$str['hpjam']['error']['ClientError'] = "An internal client error occurred";
$str['hpjam']['error']['ServerNoData'] = "No data from received MPS web server";
$str['hpjam']['error']['ServerUnreachable'] = "The MPS web server is not reachable";
$str['hpjam']['apicode'][-1] = "Not connected";         // XMLRET_NOT_CONNECTED
$str['hpjam']['apicode'][1]  = "";                      // XMLRET_ERROR
$str['hpjam']['apicode'][2]  = "Wrong parameter";       // XMLRET_PARAM_ERROR
$str['hpjam']['apicode'][5]  = "Request denied";        // XMLRET_DENIED
$str['hpjam']['apicode'][10] = "Password expired";      // XMLRET_EXPIRED
$str['hpjam']['apicode'][11] = "Object already exists"; // XMLRET_ALREADY_EXISTS
$str['hpjam']['apierror'][0]  = "Unspecified error";
$str['hpjam']['apierror'][2]  = "Login at MPS server failed";
$str['hpjam']['apierror'][3]  = "HTTP error";
$str['hpjam']['apierror'][4]  = "HP-Password expired";
$str['hpjam']['apierror'][5]  = "Login at HP server failed";
$str['hpjam']['apierror'][6]  = "Login at HP server failed because of missing credentials";
$str['hpjam']['apierror'][7]  = "HP server error";
$str['hpjam']['apierror'][8]  = "HP server request failed";
$str['hpjam']['apierror'][9]  = "User not authenticated by HP server";
$str['hpjam']['apierror'][10] = "User unauthorized on HP server";
$str['hpjam']['apierror'][11] = "Registration key invalid";
$str['hpjam']['apierror'][12] = "Functionality is not activated on MPS server";
$str['hpjam']['apierror'][13] = "Source identifier unknown at server side";
$str['hpjam']['apierror'][14] = "Missing or invalid registration email address";

// umlauta: "ä" required - do not remove this comment
// umlauto: "ö" required - do not remove this comment
// umlautu: "ü" required - do not remove this comment
?>