var g_PendingAjaxCalls = new Array();

$(window).on('beforeunload', function()
{
  ajhCancelAjaxFunctions ();
});

function AjaxCall ( sUrl, ajFktn, ajParams )
{
  var deferred = new $.Deferred();

  try
  {
    if ( typeof ajFktn === 'string' && ajFktn != '' )
    {
      var Params =
      {
        'ajhAction': ajFktn,
        'params'   : ajParams
      };

      var sRequestKey = ajhBuildRequestKey (Params);

      if (g_PendingAjaxCalls[sRequestKey] != null)
      {
        ajhCancelAjaxFunction (g_PendingAjaxCalls[sRequestKey]);

        g_PendingAjaxCalls[sRequestKey] = null;
      }

      var request = $.ajax (
          {
            url:      sUrl,
            type:     "POST",
            data:     Params,
            dataType: "json"
          })
          .done (function (data)
            {
              if (typeof data.code === 'undefined')
                data.code = 0;
              else if (data.code == 2) // Invalid session
                window.location.href = "form_login.php?sessionlost=timeout";
              else if (data.code == 3) // Server lost
                window.location.href = "form_login.php?sessionlost=invalid";

              g_PendingAjaxCalls[sRequestKey] = null;

              deferred.resolve (data);
            }
          )
          .fail (function (jqXHR, textStatus, errorThrown)
            {
              g_PendingAjaxCalls[sRequestKey] = null;

              deferred.reject(jqXHR, textStatus, errorThrown);
            }
          );

      g_PendingAjaxCalls[sRequestKey] = request;
    }
    else
      deferred.reject();
  }
  catch (e)
  {
    deferred.reject();
  }

  return deferred.promise();
}


function ajhBuildRequestKey (Params)
{
  var sRequestKey = Params['ajhAction'];
  var RequestId   = Params['ajhRequestId'];

  // Um mehrere gleichzeitige Aufrufe der ajhAction zu ermöglichen:
  if (RequestId !== undefined)
    sRequestKey = sRequestKey + '[' + RequestId + ']';

  return sRequestKey;
}


function ajhCancelAjaxFunction ( request )
{
  for (var key in g_PendingAjaxCalls)
  {
    if (g_PendingAjaxCalls[key] === request)
      g_PendingAjaxCalls[key] = null;
  }

  if (typeof request != 'undefined' && request)
    request.abort();

  // Wenn die Ajaxfunktion schneller zurückkehrt, als der Aufruf selbst,
  // ist das Handle ggf. oben noch nicht in der Liste.
  // In diesem Fall nach dem Abbruch nochmals prüfen und nullen.
  for (var key in g_PendingAjaxCalls)
  {
    if (g_PendingAjaxCalls[key] === request)
      g_PendingAjaxCalls[key] = null;
  }
}


function ajhCancelAjaxFunctions ()
{
  for (var key in g_PendingAjaxCalls)
  {
    if (g_PendingAjaxCalls[key] != null)
      ajhCancelAjaxFunction (g_PendingAjaxCalls[key]);
  }
}
