var TINY={};

TINY.box=function(){
  var p,m,b,fn,ic,iu,iw,ih,ia,f=0,hid=1,it=0,ss=3,oe=40;
  var focusableControls = "a[href], area[href], input:not([disabled]), select:not([disabled]), " +
    "textarea:not([disabled]), button:not([disabled]), iframe, object, " +
    "embed, *[tabindex], *[contenteditable]";
  var originalFocusControl;
  var aria_describedby, aria_labelledby;
  var template_id, template_class='';
  var onshow_callback=null, onhide_callback=null;
  return{
    tag:function(t){
      if(typeof t !='undefined')
        it=t;
      return it;
    },
    show:function(html,url,width,height,a,autohide,s,opacity,onshow,onhide){
      ss=3; oe=40;
      if (s){
        ss=s;
        if(opacity)
          oe=opacity;
      }
      if (p && hid==0){
        setTimeout(function(){TINY.box.show(html,url,width,height,a,autohide,ss,oe);},100);
        return;
      }
      hid=0;

      onshow_callback=onshow;
      onhide_callback=onhide;

      if(typeof html === 'string' && html.length && html[0] == '#'){
        template_id = html;
        aria_describedby = jQuery(template_id).attr('aria-describedby');
        aria_labelledby = jQuery(template_id).attr('aria-labelledby');
        template_class = jQuery(template_id).attr("class");
        if (typeof template_class !== typeof undefined && template_class !== false)
          template_class = ' ' + template_class;
        else
          template_class = '';
        html=jQuery(template_id).html();
      }

      originalFocusControl=jQuery(':focus');

      if(!f){
        m=document.createElement('div');
        m.className='tinymask';
        m.setAttribute('aria-hidden', 'true');
        document.body.appendChild(m);

        p=document.createElement('div');
        p.className='tinybox' + template_class;
        p.setAttribute('tabindex','-1');
        p.setAttribute('role','dialog');
        p.setAttribute('aria-hidden','true');
        if (typeof aria_describedby !== typeof undefined && aria_describedby !== false)
          p.setAttribute('aria-describedby', aria_describedby);
        if (typeof aria_labelledby !== typeof undefined && aria_labelledby !== false)
          p.setAttribute('aria-labelledby', aria_labelledby);
        if (typeof template_id !== typeof undefined && template_id !== false)
          jQuery(p).insertBefore( template_id );
        else
          document.body.appendChild(p);

        b=document.createElement('div');
        b.className='tinycontent';
        p.appendChild(b);

        jQuery(m).click(function(){
          if(autohide>=0)
            TINY.box.hide();
          else
            jQuery(p).focus();
        });

        if (jQuery.isFunction(jQuery.fn.button))
          jQuery(p).find('button').button();

        window.onresize=TINY.box.resize;
        f=1;
      }
      if(!a&&!url){
        this.set(html,width,height);
      }else{
        b.style.display='none';
        p.style.width=p.style.height='100px';
      }

      this.mask();
      ic=html; iu=url; iw=width; ih=height; ia=a;

      if (jQuery.isFunction(onshow_callback))
        onshow_callback();

      this.alpha(m,1,oe,ss);

      setTimeout(function()
      {
        jQuery(p).keydown(function(event){
          if (event.which == 27) {
            TINY.box.hide();
            event.preventDefault();
          }
          else if(event.which == 9) {
            var controls = jQuery(this).find('*').filter(focusableControls).filter(':visible');
            if (controls.length > 1)
            {
              var focusedControlIndex = controls.index (jQuery (':focus'));

              if ( event.shiftKey )
              {
                if ( focusedControlIndex < 1 )
                {
                  controls.get (controls.length - 1).focus ();
                  event.preventDefault ();
                }
              }
              else
              {
                if ( focusedControlIndex == controls.length - 1 )
                {
                  controls.get (0).focus ();
                  event.preventDefault ();
                }
              }
            }
            else
              event.preventDefault();
          }
        }).find(focusableControls).filter(':visible').filter('[autofocus],:first').focus();
        
        if (jQuery.isFunction(jQuery.fn.zIndex))
          jQuery('.ui-autocomplete.ui-front').zIndex (jQuery(p).zIndex());

        if(autohide>0)
          setTimeout(function(){TINY.box.hide();},1000*autohide);
      }, 100);
    },
    set:function(html,w,h){
      p.style.width=w?w+'px':'auto';
      p.style.height=h?h+'px':'auto';
      p.style.backgroundImage='none';
      b.innerHTML=html;
    },
    fill:function(html,url,w,h,a){
      if(url){
        p.style.backgroundImage='';
        var x=window.XMLHttpRequest?new XMLHttpRequest():new ActiveXObject('Microsoft.XMLHTTP');
        x.onreadystatechange=function(){
          if(x.readyState==4&&x.status==200){
            TINY.box.psh(x.responseText,w,h,a);
          }
        };
        x.open('GET',html,1);
        x.send(null);
      }else{
        this.psh(html,w,h,a);
      }
    },
    psh:function(c,w,h,a){
      if(a){
        if (typeof c == 'object')
          b.appendChild(c);
        else
          b.innerHTML = c;

        if(!w||!h){
          var x=p.style.width,
              y=p.style.height;
          p.style.width=w?w+'px':'';
          p.style.height=h?h+'px':'';
          b.style.display='';
          w=parseInt(b.offsetWidth);
          h=parseInt(b.offsetHeight);
          b.style.display='none';
          p.style.width=x;
          p.style.height=y;
        }
        this.size(p,w,h,4);
      }else{
        p.style.backgroundImage='none';
      }
    },
    hide:function(){
      if(hid==0){
        hid=1;
        TINY.box.alpha(p,-1,0,ss);
        originalFocusControl.focus();
        if (jQuery.isFunction(onhide_callback))
          if (onhide_callback() == true)
            TINY.box.destroy();
      }
    },
    destroy:function(){
      TINY.box.hide();
      if(typeof p.ai !='undefined')
        clearInterval(p.ai);
      if(typeof p.si !='undefined')
        clearInterval(p.si);
      jQuery(p).remove();
      if(typeof m.ai !='undefined')
        clearInterval(m.ai);
      if(typeof m.si !='undefined')
        clearInterval(m.si);
      jQuery(m).remove();
      f=0; p=0; m=0;
    },
    resize:function(){
      TINY.box.pos();
      TINY.box.mask();
    },
    mask:function(){
      m.style.height=TINY.page.theight()+'px';
      m.style.width=TINY.page.twidth()+'px';
    },
    pos:function(){
      var t=(TINY.page.height()/2)-(p.offsetHeight/2); t=t<10?10:t;
      p.style.top=(t+TINY.page.top())+'px';
      p.style.left=(TINY.page.width()/2)-(p.offsetWidth/2)+'px';
    },
    alpha:function(e,d,a,s){
      clearInterval(e.ai);
      if(d==1){
        e.style.opacity=0;
        e.style.filter='alpha(opacity=0)';
        e.style.display='block';
        e.setAttribute('aria-hidden','false');
        this.pos();
      }
      e.ai=setInterval(function(){TINY.box.twalpha(e,a,d,s);},20);
    },
    twalpha:function(e,a,d,s){
      var o=Math.round(e.style.opacity*100);
      if(o==a){
        clearInterval(e.ai);
        if(d==-1){
          e.style.display='none';
          e.setAttribute('aria-hidden','true');
          if(e==p)
            TINY.box.alpha(m,-1,0,s);
          else {
            (b.innerHTML=p.style.backgroundImage='');
            hid=1;
          }
        } else {
          if (e == m) {
            this.alpha(p, 1, 100, s);
          } else {
            TINY.box.fill(ic, iu, iw, ih, ia);
          }
        }
      }else {
        var n=o+Math.ceil(Math.abs(a-o)/s)*d;
        e.style.opacity=n/100;
        e.style.filter='alpha(opacity='+n+')';
      }
    },
    size:function(e,w,h,s){
      if (typeof e != 'object')
        e = document.getElementById(e);
      clearInterval(e.si);
      var ow=e.offsetWidth,
          oh=e.offsetHeight,
          wo=ow-parseInt(e.style.width),
          ho=oh-parseInt(e.style.height);
      var wd=ow-wo>w?-1:1,
          hd=(oh-ho>h)?-1:1;
      e.si=setInterval(function(){TINY.box.twsize(e,w,wo,wd,h,ho,hd,s);},20);
    },
    twsize:function(e,w,wo,wd,h,ho,hd,s){
      var ow=e.offsetWidth-wo,
          oh=e.offsetHeight-ho;
      if(ow==w&&oh==h){
        clearInterval(e.si);
        p.style.backgroundImage='none';
        b.style.display='block';
      }else{
        if(ow!=w){e.style.width=ow+(Math.ceil(Math.abs(w-ow)/s)*wd)+'px';}
        if(oh!=h){e.style.height=oh+(Math.ceil(Math.abs(h-oh)/s)*hd)+'px';}
        this.pos();
      }
    }
  };
}();

TINY.page=function(){
  return{
    top:function(){return document.body.scrollTop||document.documentElement.scrollTop;},
    width:function(){return self.innerWidth||document.documentElement.clientWidth;},
    height:function(){return self.innerHeight||document.documentElement.clientHeight;},
    theight:function(){
      var d=document, b=d.body, e=d.documentElement;
      return Math.max(Math.max(b.scrollHeight,e.scrollHeight),Math.max(b.clientHeight,e.clientHeight));
    },
    twidth:function(){
      var d=document, b=d.body, e=d.documentElement;
      return Math.max(Math.max(b.scrollWidth,e.scrollWidth),Math.max(b.clientWidth,e.clientWidth));
    }
  };
}();
