<?php
// toolbox.inc.php
// Copyright P.Kassel, M.Seliger, G.Trietsch, all Rights Reserved
function tbArrayFromCommaText($CommaText,$ElementName1,$ElementName2):array{$Result=array();if(strlen($CommaText)>0){$tok=strtok($CommaText,";");while($tok!==false){if(strlen($ElementName1)||strlen($ElementName2)){$Element=array();if(strlen($ElementName1))$Element[$ElementName1]=$tok;$tok=strtok(";");if(strlen($ElementName2)){$Element[$ElementName2]=$tok;$tok=strtok(";");}}else{$Element=$tok;$tok=strtok(";");}array_push($Result,$Element);}}return $Result;}function tbAsc2Bin($temp):string{$data='';$len=strlen($temp);for($i=0;$i<$len;$i++)$data.=sprintf("%08b",ord(substr($temp,$i,1)));return $data;}function tbBinHex($bin):string{$hex='';for($i=strlen($bin)-4;$i>=0;$i-=4)$hex.=dechex(bindec(substr($bin,$i,4)));return strrev($hex);}function tbBin2Asc($temp):string{$data='';$len=strlen($temp);for($i=0;$i<$len;$i+=8)$data.=chr(bindec(substr($temp,$i,8)));return $data;}function tbHexBin($hex):string{$bin='';for($i=0;$i<strlen($hex);$i++)$bin.=str_pad(decbin(hexdec($hex[$i])),4,'0',STR_PAD_LEFT);return $bin;}class tbIniFile{private $IniFileName;private $Items;public function __construct($IniFileName){$this->IniFileName=$IniFileName;$this->Items=array();tbIniFile::Load();}public function ReadValue($Section,$Ident,$Default=""){$Result=$Default;if(is_array($this->Items)&&isset($this->Items[$Section])&&isset($this->Items[$Section][$Ident]))$Result=$this->Items[$Section][$Ident];return $Result;}public function WriteValue($Section,$Ident,$Value):void{if(is_array($this->Items))$this->Items[$Section][$Ident]=$Value;}private function Load():void{$this->Items=array();$sec="";$comment_chars=";#";$num_comments=0;$num_newline=0;$f=@file($this->IniFileName);if($f===false)return;for($i=0;$i<@count($f);$i++){$w=@trim($f[$i]);$first_char=@substr($w,0,1);if($w){if((@substr($w,0,1)=="[")and(@substr($w,-1,1))=="]"){$sec=@substr($w,1,@strlen($w)-2);$num_comments=0;$num_newline=0;}else if(stristr($comment_chars,$first_char)==true){$this->Items[$sec]["comment_".$num_comments]=$w;$num_comments=$num_comments+1;}else{$w=@explode("=",$w);$k=@trim($w[0]);unset($w[0]);$v=@trim(@implode("=",$w));if((@substr($v,0,1)=="\"")and(@substr($v,-1,1)=="\""))$v=@substr($v,1,@strlen($v)-2);$this->Items[$sec][$k]=$v;}}else{$this->Items[$sec]["newline_".$num_newline]=$w;$num_newline=$num_newline+1;}}}public function UpdateFile():void{$content="";foreach($this->Items as $key=>$elem){if(is_array($elem)){if($key!='')$content.="[".$key."]\r\n";foreach($elem as $key2=>$elem2){if($this->beginsWith($key2,'comment_')==1&&$this->beginsWith($elem2,';'))$content.=$elem2."\r\n";else if($this->beginsWith($key2,'newline_')==1&&($elem2==''))$content.=$elem2."\r\n";else $content.=$key2."=".$elem2."\r\n";}}else $content.=$key."=".$elem."\r\n";}if(!$handle=fopen($this->IniFileName,'w'))return;if(!fwrite($handle,$content))return;fclose($handle);}private function beginsWith($str,$sub):bool{return(substr($str,0,strlen($sub))===$sub);}}function tbIso8601toHTML($IsoDate,$Format):string{$HtmlDate='';$Date=(isset($IsoDate)?$IsoDate->scalar:'');if(strlen($Date)>0){$rep_date_d=substr($Date,6,2);$rep_date_m=substr($Date,4,2);$rep_date_y=substr($Date,0,4);$rep_time_hour=substr($Date,9,2);$rep_time_min=substr($Date,12,2);$rep_time_sec=substr($Date,15,2);if(checkdate($rep_date_m,$rep_date_d,$rep_date_y)){$php_ts=gmmktime($rep_time_hour,$rep_time_min,$rep_time_sec,$rep_date_m,$rep_date_d,$rep_date_y);$HtmlDate=date($Format,$php_ts);}}return $HtmlDate;}function tbGetSysRscString($group,$name,$def){$text=$def;if(isset($_SESSION['SysRsc'][$group][$name]))$text=$_SESSION['SysRsc'][$group][$name];return $text;}function tbCidrToNetmask($cidr):bool|string{$bin='';for($i=1;$i<=32;$i++)$bin.=$cidr>=$i?'1':'0';$netmask=long2ip(bindec($bin));if($netmask=='0.0.0.0')return false;return $netmask;}function tbNetmaskToCidr($netmask):int{$bits=0;$netmask=explode(".",$netmask);foreach($netmask as $octect)$bits+=strlen(str_replace("0","",decbin($octect)));return $bits;}function tbNetworkFromIP($ip,$cidr):string{$network=long2ip((ip2long($ip))&((-1<<(32-(int)$cidr))));return $network;}function tbIsIPInNetwork($ip,$network,$cidr):bool{if((ip2long($ip)&~((1<<(32-$cidr))-1))==ip2long($network))return true;else return false;}function tbFirstIP($network,$cidr):string{$bin='';for($i=1;$i<=32;$i++)$bin.=$cidr>=$i?'1':'0';$net=ip2long($network)& bindec($bin);return long2ip($net+1);}function tbLastIP($network,$cidr):string{$bin='';for($i=1;$i<=32;$i++)$bin.=$cidr>=$i?'1':'0';$mask=bindec($bin);$net=ip2long($network)& $mask;$net|=((0xFFFFFFFF^$mask)-1);return long2ip($net);}function tbBroadcastIP($network,$cidr):string{$bin='';for($i=1;$i<=32;$i++)$bin.=$cidr>=$i?'1':'0';$mask=bindec($bin);$net=ip2long($network)& $mask;$net|=(0xFFFFFFFF^$mask);return long2ip($net);}function tbUtf8ToLatin1(& $text):string|array{if(is_array($text)){foreach((array)$text as $key=>$val){if(gettype($val)==='string')$text[$key]=iconv("UTF-8","windows-1252",$val);}return $text;}else{return iconv("UTF-8","windows-1252",$text);}}function tbCodeUtf8Password($text):string|array{return@tbUtf8ToLatin1($text);}function tbCreate128BitKey($passphrase,$salt):string{$key=hash('sha256',$passphrase.$salt);$key=substr($key,0,32);return $key;}function tbCryptAES128($text,$passphrase,$salt):string{$key=tbCreate128BitKey($passphrase,$salt);return tbCryptAES128_K($text,$key);}function tbPad16($text){$len=strlen($text);if($len>0){$padlen=($len+(15-(($len+15)%16)));$text=str_pad($text,$padlen,"\0",STR_PAD_RIGHT);}return $text;}function tbCryptAES128_K($text,$key):string{$encrypted='';$hkey=pack("H*",$key);if($text!=''){$text=tbPad16($text);$options=OPENSSL_RAW_DATA|OPENSSL_ZERO_PADDING;$encrypted=openssl_encrypt($text,"AES-128-ECB",$hkey,$options,"");if($encrypted!==false)$encrypted=base64_encode($encrypted);else $encrypted='';}return $encrypted;}function tbDecryptAES128($crypted_text,$passphrase,$salt):string{$key=tbCreate128BitKey($passphrase,$salt);return tbDecryptAES128_K($crypted_text,$key);}function tbDecryptAES128_K($crypted_text,$key):string{$hkey=pack("H*",$key);$crypted_text=base64_decode($crypted_text);$options=OPENSSL_RAW_DATA|OPENSSL_ZERO_PADDING;$decrypted=openssl_decrypt($crypted_text,"AES-128-ECB",$hkey,$options,"");if($decrypted!==false)$decrypted=str_replace("\0","",$decrypted);else $decrypted='';return $decrypted;} ?>